// To parse this JSON data, do
//
//     final addMoneyHistoryResponseModel = addMoneyHistoryResponseModelFromJson(jsonString);

// ignore_for_file: prefer_null_aware_operators

import 'dart:convert';

import 'package:viserpay_agent/data/model/auth/sign_up_model/registration_response_model.dart';

AddMoneyHistoryResponseModel addMoneyHistoryResponseModelFromJson(String str) => AddMoneyHistoryResponseModel.fromJson(json.decode(str));

String addMoneyHistoryResponseModelToJson(AddMoneyHistoryResponseModel data) => json.encode(data.toJson());

class AddMoneyHistoryResponseModel {
  String? remark;
  String? status;
  Data? data;
  Message? message;

  AddMoneyHistoryResponseModel({this.remark, this.status, this.data, this.message});

  factory AddMoneyHistoryResponseModel.fromJson(Map<String, dynamic> json) => AddMoneyHistoryResponseModel(
        remark: json["remark"],
        status: json["stutas"],
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "stutas": status,
        "data": data?.toJson(),
      };
}

class Data {
  Logs? logs;

  Data({
    this.logs,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        logs: json["logs"] == null ? null : Logs.fromJson(json["logs"]),
      );

  Map<String, dynamic> toJson() => {
        "logs": logs?.toJson(),
      };
}

class Logs {
  int? currentPage;
  List<DepositsData>? data;
  String? firstPageUrl;
  int? from;
  int? lastPage;
  String? lastPageUrl;

  dynamic nextPageUrl;
  String? path;
  int? perPage;
  dynamic prevPageUrl;
  int? to;
  int? total;

  Logs({
    this.currentPage,
    this.data,
    this.firstPageUrl,
    this.from,
    this.lastPage,
    this.lastPageUrl,
    this.nextPageUrl,
    this.path,
    this.perPage,
    this.prevPageUrl,
    this.to,
    this.total,
  });

  factory Logs.fromJson(Map<String, dynamic> json) => Logs(
        currentPage: json["current_page"],
        data: json["data"] == null ? [] : List<DepositsData>.from(json["data"]!.map((x) => DepositsData.fromJson(x))),
        firstPageUrl: json["first_page_url"],
        from: json["from"],
        lastPage: json["last_page"],
        lastPageUrl: json["last_page_url"],
        nextPageUrl: json["next_page_url"],
        path: json["path"],
        perPage: json["per_page"],
        prevPageUrl: json["prev_page_url"],
        to: json["to"],
        total: json["total"],
      );

  Map<String, dynamic> toJson() => {
        "current_page": currentPage,
        "data": data == null ? [] : List<DepositsData>.from(data!.map((x) => x.toString())),
        "first_page_url": firstPageUrl,
        "from": from,
        "last_page": lastPage,
        "last_page_url": lastPageUrl,
        "next_page_url": nextPageUrl,
        "path": path,
        "per_page": perPage,
        "prev_page_url": prevPageUrl,
        "to": to,
        "total": total,
      };
}

class DepositsData {
  int? id;
  String? userId;
  String? userType;
  String? methodCode;
  String? amount;
  String? methodCurrency;
  String? charge;
  String? rate;
  String? finalAmo;
  String? btcAmo;
  String? btcWallet;
  String? trx;
  String? paymentTry;
  String? status;
  String? fromApi;
  dynamic adminFeedback;
  String? createdAt;
  String? updatedAt;
  Gateway? gateway;

  DepositsData({
    this.id,
    this.userId,
    this.userType,
    this.methodCode,
    this.amount,
    this.methodCurrency,
    this.charge,
    this.rate,
    this.finalAmo,
    this.btcAmo,
    this.btcWallet,
    this.trx,
    this.paymentTry,
    this.status,
    this.fromApi,
    this.adminFeedback,
    this.createdAt,
    this.updatedAt,
    this.gateway,
  });

  factory DepositsData.fromJson(Map<String, dynamic> json) => DepositsData(
        id: json["id"],
        userId: json["user_id"].toString(),
        userType: json["user_type"].toString(),
        methodCode: json["method_code"].toString(),
        amount: json["amount"].toString(),
        methodCurrency: json["method_currency"].toString(),
        charge: json["charge"].toString(),
        rate: json["rate"].toString(),
        finalAmo: json["final_amount"].toString(),
        btcAmo: json["btc_amo"].toString(),
        btcWallet: json["btc_wallet"].toString(),
        trx: json["trx"].toString(),
        paymentTry: json["payment_try"].toString(),
        status: json["status"].toString(),
        fromApi: json["from_api"].toString(),
        adminFeedback: json["admin_feedback"].toString(),
        createdAt: json["created_at"] == null ? null : json["created_at"].toString(),
        updatedAt: json["updated_at"] == null ? null : json["updated_at"].toString(),
        gateway: json["gateway"] == null ? null : Gateway.fromJson(json["gateway"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "user_id": userId,
        "user_type": userType,
        "method_code": methodCode,
        "amount": amount,
        "method_currency": methodCurrency,
        "charge": charge,
        "rate": rate,
        "final_amo": finalAmo,
        "btc_amo": btcAmo,
        "btc_wallet": btcWallet,
        "trx": trx,
        "payment_try": paymentTry,
        "status": status,
        "from_api": fromApi,
        "admin_feedback": adminFeedback,
        "created_at": createdAt?.toString(),
        "updated_at": updatedAt?.toString(),
        "gateway": gateway?.toJson(),
      };
}

class Gateway {
  int? id;
  String? formId;
  String? code;
  String? name;
  String? alias;
  String? status;
  String? crypto;
  dynamic description;
  String? createdAt;
  String? updatedAt;

  Gateway({
    this.id,
    this.formId,
    this.code,
    this.name,
    this.alias,
    this.status,
    this.crypto,
    this.description,
    this.createdAt,
    this.updatedAt,
  });

  factory Gateway.fromJson(Map<String, dynamic> json) => Gateway(
        id: json["id"],
        formId: json["form_id"].toString(),
        code: json["code"].toString(),
        name: json["name"].toString(),
        alias: json["alias"].toString(),
        status: json["status"].toString(),
        crypto: json["crypto"].toString(),
        description: json["description"].toString(),
        createdAt: json["created_at"] == null ? null : json["created_at"].toString(),
        updatedAt: json["updated_at"] == null ? null : json["updated_at"].toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "form_id": formId,
        "code": code,
        "name": name,
        "alias": alias,
        "status": status,
        "crypto": crypto,
        "description": description,
        "created_at": createdAt?.toString(),
        "updated_at": updatedAt?.toString(),
      };
}
